//
//  MCTableSortChooser.h
//  MCApplication
//
//  Created by Ali Lalani on 04/02/06.
//  Copyright 2006 __MyCompanyName__. All rights reserved.
//

#import <Cocoa/Cocoa.h>

#import "MCWindowController.h"

@interface MCTableSortChooser : MCWindowController {
	IBOutlet NSArrayController *primaryController;
	IBOutlet NSArrayController *secondaryController;
	
	IBOutlet NSButton *priDirectionButton;
	IBOutlet NSButton *secDirectionButton;
	
	NSArray *columns;
	NSArray *sortDescriptors;
	
	NSMutableArray *primaryColumns;
	NSMutableArray *secondaryColumns;

	NSDictionary *primarySortColumn;
	NSDictionary *secondarySortColumn;

	BOOL primaryAscending;
	BOOL secondaryAscending;
}
- (id)initWithTableColumnConfigurationIdentifier:(NSString *)anIdentifier currentSortDescriptors:(NSArray *)sortDescriptors;

- (IBAction)ok:(id)sender;
- (IBAction)cancel:(id)sender;

- (void)cleanUp;

#pragma mark Accessors
- (NSArray *)columns;
- (void)setColumns:(NSArray *)aColumns;

- (NSArray *)sortDescriptors;
- (void)setSortDescriptors:(NSArray *)aSortDescriptors;

- (NSMutableArray *)primaryColumns;
- (void)setPrimaryColumns:(NSMutableArray *)aPrimaryColumns;
- (NSMutableArray *)secondaryColumns;
- (void)setSecondaryColumns:(NSMutableArray *)aSecondaryColumns;

- (NSDictionary *)primarySortColumn;
- (void)setPrimarySortColumn:(NSDictionary *)aPrimarySortColumn;
- (NSDictionary *)secondarySortColumn;
- (void)setSecondarySortColumn:(NSDictionary *)aSecondarySortColumn;

- (BOOL)primaryAscending;
- (void)setPrimaryAscending:(BOOL)flag;
- (BOOL)secondaryAscending;
- (void)setSecondaryAscending:(BOOL)flag;
@end
